// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/serial/serial.mojom
//

package org.chromium.mojom.device.serial;

public final class DeviceControlSignals extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 16;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public boolean dcd;
    public boolean cts;
    public boolean ri;
    public boolean dsr;

    private DeviceControlSignals(int version) {
        super(STRUCT_SIZE, version);
    }

    public DeviceControlSignals() {
        this(0);
    }

    public static DeviceControlSignals deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static DeviceControlSignals decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        DeviceControlSignals result = new DeviceControlSignals(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.dcd = decoder0.readBoolean(8, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.cts = decoder0.readBoolean(8, 1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.ri = decoder0.readBoolean(8, 2);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.dsr = decoder0.readBoolean(8, 3);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(dcd, 8, 0);
        encoder0.encode(cts, 8, 1);
        encoder0.encode(ri, 8, 2);
        encoder0.encode(dsr, 8, 3);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        DeviceControlSignals other = (DeviceControlSignals) object;
        if (this.dcd != other.dcd)
            return false;
        if (this.cts != other.cts)
            return false;
        if (this.ri != other.ri)
            return false;
        if (this.dsr != other.dsr)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(dcd);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(cts);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(ri);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(dsr);
        return result;
    }
}

